/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa.commands;

import me.mulemuledupe.simpletpa.SimpleTpa;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class TpaHereCommand
implements CommandExecutor {
    SimpleTpa plugin;

    public TpaHereCommand(SimpleTpa plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.utils.consoleSendMessage(sender);
            return true;
        }
        Player p = (Player)sender;
        if (!this.plugin.utils.checkDisabledWorlds(p)) {
            return false;
        }
        if (!p.hasPermission("simpletpa.bypasscooldown")) {
            long elapsed;
            int cooldown = this.plugin.getConfig().getInt("tpahere-cooldown");
            for (PermissionAttachmentInfo pai : p.getEffectivePermissions()) {
                String perm = pai.getPermission().toLowerCase();
                if (!pai.getValue() || !perm.startsWith("simpletpa.cooldown.tpahere.")) continue;
                String tail = perm.substring("simpletpa.cooldown.tpahere.".length());
                try {
                    cooldown = Math.max(0, Integer.parseInt(tail));
                }
                catch (NumberFormatException ignored) {
                    this.plugin.getLogger().warning("[SimpleTpa] Invalid cooldown permission value: " + perm);
                }
            }
            Long last = this.plugin.storage.tpaHereCooldown.get(p.getUniqueId());
            if (last != null && (elapsed = (System.currentTimeMillis() - last) / 1000L) < (long)cooldown) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Cooldown-Message").replace("%time%", String.valueOf((long)cooldown - elapsed)));
                return true;
            }
        }
        if (args.length > 0) {
            if (p.hasPermission("simpletpa.tpahere")) {
                Player target = Bukkit.getServer().getPlayer(args[0]);
                if (target != null) {
                    if (!this.plugin.utils.checkGamemode(p, p) || !this.plugin.utils.checkGamemode(target, p)) {
                        return false;
                    }
                    if (target == p) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Player"));
                        return false;
                    }
                    if (this.plugin.utils.isVanished(target)) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Null"));
                        return false;
                    }
                    if (this.plugin.getConfig().getBoolean("disable-interdimensional-travel") && !target.getWorld().getName().equalsIgnoreCase(p.getWorld().getName())) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Not-Same-World"));
                        return false;
                    }
                    if (this.plugin.getConfig().getStringList("disabled-worlds").contains(target.getWorld().getName())) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-In-Disabled-World"));
                        return false;
                    }
                    if (!this.plugin.storage.tpaToggled.contains(target.getUniqueId())) {
                        if (this.plugin.storage.tpaIgnoredPlayers.containsKey(target.getUniqueId()) && this.plugin.storage.tpaIgnoredPlayers.get(target.getUniqueId()).contains(p.getUniqueId())) {
                            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Has-Ignored-You"));
                        } else if (!this.plugin.storage.tpaHereRequest.containsKey(p.getUniqueId()) && !this.plugin.storage.tpaHereRequest.containsKey(target.getUniqueId())) {
                            long keepAliveRequest = this.plugin.getConfig().getLong("keep-alive") * 20L;
                            this.plugin.utils.sendTRequest(p, target);
                            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.utils.cancelTRequest(target), keepAliveRequest);
                        } else {
                            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Already-A-TPHere-Request"));
                        }
                    } else {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("TpaToggled-Player-Message"));
                    }
                } else {
                    this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Null"));
                }
            } else {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("No-Permission-Message"));
            }
        } else {
            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Tpa-Here-Usage-Message"));
        }
        return true;
    }
}

