/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa.commands;

import me.mulemuledupe.simpletpa.SimpleTpa;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class TpaCommand
implements CommandExecutor {
    SimpleTpa plugin;

    public TpaCommand(SimpleTpa plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.utils.consoleSendMessage(sender);
            return true;
        }
        Player p = (Player)sender;
        if (!this.plugin.utils.checkDisabledWorlds(p)) {
            return false;
        }
        if (!p.hasPermission("simpletpa.bypasscooldown")) {
            long elapsed;
            int cooldown = this.plugin.getConfig().getInt("tpa-cooldown");
            for (PermissionAttachmentInfo pai : p.getEffectivePermissions()) {
                String perm = pai.getPermission().toLowerCase();
                if (!pai.getValue() || !perm.startsWith("simpletpa.cooldown.tpa.")) continue;
                String tail = perm.substring("simpletpa.cooldown.tpa.".length());
                try {
                    cooldown = Math.max(0, Integer.parseInt(tail));
                }
                catch (NumberFormatException ignored) {
                    this.plugin.getLogger().warning("[SimpleTpa] Invalid cooldown permission value: " + perm);
                }
            }
            Long last = this.plugin.storage.tpaCooldown.get(p.getUniqueId());
            if (last != null && (elapsed = (System.currentTimeMillis() - last) / 1000L) < (long)cooldown) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Cooldown-Message").replace("%time%", String.valueOf((long)cooldown - elapsed)));
                return true;
            }
        }
        if (args.length > 0) {
            if (p.hasPermission("simpletpa.tpa")) {
                Player target = Bukkit.getServer().getPlayer(args[0]);
                if (target != null) {
                    if (!this.plugin.utils.checkGamemode(p, p) || !this.plugin.utils.checkGamemode(target, p)) {
                        return false;
                    }
                    if (target == p) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Player"));
                        return false;
                    }
                    if (this.plugin.utils.isVanished(target)) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Null"));
                        return false;
                    }
                    if (this.plugin.getConfig().getBoolean("disable-interdimensional-travel") && !target.getWorld().getName().equalsIgnoreCase(p.getWorld().getName())) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Not-Same-World"));
                        return false;
                    }
                    if (this.plugin.getConfig().getStringList("disabled-worlds").contains(target.getWorld().getName())) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-In-Disabled-World"));
                        return false;
                    }
                    if (!this.plugin.storage.tpaToggled.contains(target.getUniqueId())) {
                        if (this.plugin.storage.tpaIgnoredPlayers.containsKey(target.getUniqueId()) && this.plugin.storage.tpaIgnoredPlayers.get(target.getUniqueId()).contains(p.getUniqueId())) {
                            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Has-Ignored-You"));
                        } else if (this.plugin.storage.tpAuto.contains(target.getUniqueId())) {
                            int delay = this.plugin.getConfig().getInt("delay-teleportation");
                            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Teleport-Message-Back-To-Sender").replace("%player%", p.getName()));
                            this.plugin.storage.locationPlayers.put(p.getUniqueId(), p.getLocation());
                            this.plugin.utils.sendMessage(target, this.plugin.getConfig().getString("Teleport-Message-Back-To-Player"));
                            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Teleport-Message-TPAUTO").replace("%time%", String.valueOf(delay)));
                            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                if (!this.plugin.getConfig().getStringList("disabled-worlds").contains(target.getWorld().getName()) && !this.plugin.getConfig().getStringList("disabled-worlds").contains(p.getWorld().getName())) {
                                    if (this.plugin.storage.locationPlayers.containsKey(p.getUniqueId())) {
                                        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-particles")) {
                                            this.plugin.versionHandler.particleSpawn(target, Particle.valueOf((String)this.plugin.getConfig().getString("Particle-Name")));
                                            this.plugin.versionHandler.particleSpawn(p, Particle.valueOf((String)this.plugin.getConfig().getString("Particle-Name")));
                                        }
                                        if (!this.plugin.getConfig().getBoolean("disable-back-on-tp")) {
                                            this.plugin.storage.backCommandLocation.put(p.getUniqueId(), p.getLocation());
                                        }
                                        this.plugin.utils.runInvincibilityTask(p);
                                        this.plugin.utils.runInvincibilityTask(target);
                                        p.teleport((Entity)target);
                                        this.plugin.storage.tpaCooldown.put(p.getUniqueId(), System.currentTimeMillis());
                                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Teleported-Message"));
                                        this.plugin.utils.sendMessage(target, this.plugin.getConfig().getString("Teleported-Message"));
                                        this.plugin.storage.locationPlayers.remove(p.getUniqueId());
                                        this.plugin.storage.tpaRequest.remove(target.getUniqueId());
                                    } else {
                                        if (this.plugin.storage.locationPlayers.containsKey(p.getUniqueId())) {
                                            this.plugin.storage.locationPlayers.remove(p.getUniqueId());
                                        }
                                        if (this.plugin.storage.tpaRequest.containsKey(target.getUniqueId())) {
                                            this.plugin.storage.tpaRequest.remove(target.getUniqueId());
                                        }
                                    }
                                } else {
                                    this.plugin.utils.sendMessage(target, this.plugin.getConfig().getString("Disabled-World-Message"));
                                    this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-In-Disabled-World"));
                                    if (this.plugin.storage.locationPlayers.containsKey(p.getUniqueId()) && this.plugin.storage.tpaRequest.containsKey(target.getUniqueId())) {
                                        this.plugin.storage.locationPlayers.remove(p.getUniqueId());
                                        this.plugin.storage.tpaRequest.remove(target.getUniqueId());
                                    } else {
                                        if (this.plugin.storage.locationPlayers.containsKey(p.getUniqueId())) {
                                            this.plugin.storage.locationPlayers.remove(p.getUniqueId());
                                        }
                                        if (this.plugin.storage.tpaRequest.containsKey(target.getUniqueId())) {
                                            this.plugin.storage.tpaRequest.remove(target.getUniqueId());
                                        }
                                    }
                                }
                            }, (long)delay * 20L);
                        } else if (!this.plugin.storage.tpaRequest.containsKey(p.getUniqueId()) && !this.plugin.storage.tpaRequest.containsKey(target.getUniqueId())) {
                            long keepAliveRequest = this.plugin.getConfig().getLong("keep-alive") * 20L;
                            this.plugin.utils.sendRequest(p, target);
                            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.utils.cancelRequest(target), keepAliveRequest);
                        } else {
                            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Already-A-TP-Request"));
                        }
                    } else {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("TpaToggled-Player-Message"));
                    }
                } else {
                    this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Null"));
                }
            } else {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("No-Permission-Message"));
            }
        } else {
            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Tpa-Usage-Message"));
        }
        return true;
    }
}

