/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa.commands;

import me.mulemuledupe.simpletpa.SimpleTpa;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class BackCommand
implements CommandExecutor {
    SimpleTpa plugin;

    public BackCommand(SimpleTpa plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Location prev;
        if (!(sender instanceof Player)) {
            this.plugin.utils.consoleSendMessage(sender);
            return true;
        }
        Player p = (Player)sender;
        if (!this.plugin.utils.checkDisabledWorlds(p)) {
            return true;
        }
        int cooldown = this.plugin.getConfig().getInt("back-cooldown");
        if (!p.hasPermission("simpletpa.bypasscooldown")) {
            long elapsed;
            for (PermissionAttachmentInfo pai : p.getEffectivePermissions()) {
                String perm = pai.getPermission().toLowerCase();
                if (!pai.getValue() || !perm.startsWith("simpletpa.cooldown.back.")) continue;
                String tail = perm.substring("simpletpa.cooldown.back.".length());
                try {
                    cooldown = Math.max(0, Integer.parseInt(tail));
                }
                catch (NumberFormatException ignored) {
                    this.plugin.getLogger().warning("[SimpleTpa] Invalid cooldown permission value: " + perm);
                }
            }
            Long last = this.plugin.storage.backCooldown.get(p.getUniqueId());
            if (last != null && (elapsed = (System.currentTimeMillis() - last) / 1000L) < (long)cooldown) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Cooldown-Message").replace("%time%", String.valueOf((long)cooldown - elapsed)));
                return true;
            }
        }
        if (args.length == 0) {
            if (!p.hasPermission("simpletpa.back")) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("No-Permission-Message"));
                return true;
            }
            if (!this.plugin.storage.backCommandLocation.containsKey(p.getUniqueId())) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Doesnt-Have-Back-Point-1"));
                return true;
            }
            Location backLoc = this.plugin.storage.backCommandLocation.get(p.getUniqueId());
            if (backLoc == null || backLoc.getWorld() == null) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("World-Doesnt-Exists-Or-Unloaded"));
                return true;
            }
            World w = Bukkit.getWorld((String)backLoc.getWorld().getName());
            if (w == null) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("World-Doesnt-Exists-Or-Unloaded"));
                return true;
            }
            if (this.plugin.getConfig().getStringList("disabled-worlds").contains(w.getName())) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Disabled-World-Message"));
                return true;
            }
            int delay = this.plugin.getConfig().getInt("delay-back-command");
            if (delay != 0) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Teleport-Message").replace("%time%", String.valueOf(delay)));
            }
            if (delay == 0) {
                prev = p.getLocation();
                if (this.plugin.utils.safeTeleport(p, backLoc)) {
                    this.plugin.utils.runInvincibilityTask(p);
                    this.plugin.storage.backCommandLocation.put(p.getUniqueId(), prev);
                    this.plugin.storage.backCooldown.put(p.getUniqueId(), System.currentTimeMillis());
                }
            } else {
                this.plugin.storage.locationBackPlayers.put(p.getUniqueId(), p.getLocation());
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (!this.plugin.storage.locationBackPlayers.containsKey(p.getUniqueId())) {
                        return;
                    }
                    Location bl = this.plugin.storage.backCommandLocation.get(p.getUniqueId());
                    if (bl == null || bl.getWorld() == null) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("World-Doesnt-Exists-Or-Unloaded"));
                        this.plugin.storage.locationBackPlayers.remove(p.getUniqueId());
                        return;
                    }
                    World w2 = Bukkit.getWorld((String)bl.getWorld().getName());
                    if (w2 == null) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("World-Doesnt-Exists-Or-Unloaded"));
                        this.plugin.storage.locationBackPlayers.remove(p.getUniqueId());
                        return;
                    }
                    if (this.plugin.getConfig().getStringList("disabled-worlds").contains(w2.getName())) {
                        this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Disabled-World-Message"));
                        this.plugin.storage.locationBackPlayers.remove(p.getUniqueId());
                        return;
                    }
                    Location prev = p.getLocation();
                    if (this.plugin.utils.safeTeleport(p, bl)) {
                        this.plugin.utils.runInvincibilityTask(p);
                        this.plugin.storage.backCommandLocation.put(p.getUniqueId(), prev);
                        this.plugin.storage.backCooldown.put(p.getUniqueId(), System.currentTimeMillis());
                    }
                    this.plugin.storage.locationBackPlayers.remove(p.getUniqueId());
                }, (long)delay * 20L);
            }
        } else {
            if (!p.hasPermission("simpletpa.back.others")) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("No-Permission-Message"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Is-Null"));
                return true;
            }
            if (!this.plugin.storage.backCommandLocation.containsKey(target.getUniqueId())) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Player-Doesnt-Have-Back-Point"));
                return true;
            }
            Location backLoc = this.plugin.storage.backCommandLocation.get(target.getUniqueId());
            if (backLoc == null || backLoc.getWorld() == null) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("World-Doesnt-Exists-Or-Unloaded"));
                return true;
            }
            World w = Bukkit.getWorld((String)backLoc.getWorld().getName());
            if (w == null) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("World-Doesnt-Exists-Or-Unloaded"));
                return true;
            }
            if (this.plugin.getConfig().getStringList("disabled-worlds").contains(w.getName())) {
                this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Disabled-World-Message"));
                return true;
            }
            prev = target.getLocation();
            if (this.plugin.utils.safeTeleport(target, backLoc)) {
                this.plugin.utils.runInvincibilityTask(target);
                this.plugin.storage.backCommandLocation.put(target.getUniqueId(), prev);
            }
        }
        return true;
    }
}

