/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.mulemuledupe.simpletpa.commands.BackCommand;
import me.mulemuledupe.simpletpa.commands.BackCommandTabCompletion;
import me.mulemuledupe.simpletpa.commands.SimpleTpaCommand;
import me.mulemuledupe.simpletpa.commands.TpaCommand;
import me.mulemuledupe.simpletpa.commands.TpaCommandTabCompletion;
import me.mulemuledupe.simpletpa.commands.TpaHereCommand;
import me.mulemuledupe.simpletpa.commands.TpaHereCommandTabCompletion;
import me.mulemuledupe.simpletpa.commands.TpaIgnoreCommand;
import me.mulemuledupe.simpletpa.commands.TpaToggleCommand;
import me.mulemuledupe.simpletpa.commands.TpaToggleCommandTabCompletion;
import me.mulemuledupe.simpletpa.commands.TpacceptCommand;
import me.mulemuledupe.simpletpa.commands.TpahereallCommand;
import me.mulemuledupe.simpletpa.commands.TpautoCommand;
import me.mulemuledupe.simpletpa.commands.TpcancelCommand;
import me.mulemuledupe.simpletpa.commands.TpcancelCommandTabCompletion;
import me.mulemuledupe.simpletpa.commands.TpdenyCommand;
import me.mulemuledupe.simpletpa.compability.VersionHandler;
import me.mulemuledupe.simpletpa.compability.v1_13.Handler_v1_13;
import me.mulemuledupe.simpletpa.events.DeathEvent;
import me.mulemuledupe.simpletpa.events.JoinAndLeaveEvents;
import me.mulemuledupe.simpletpa.events.MoveEvent;
import me.mulemuledupe.simpletpa.events.TeleportEvent;
import me.mulemuledupe.simpletpa.placeholders.SimpleTpaExpansion;
import me.mulemuledupe.simpletpa.utils.MessageUtil;
import me.mulemuledupe.simpletpa.utils.MetricsLite;
import me.mulemuledupe.simpletpa.utils.SimpleTpaUtils;
import me.mulemuledupe.simpletpa.utils.StorageClass;
import me.mulemuledupe.simpletpa.utils.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SimpleTpa
extends JavaPlugin {
    public SimpleTpaUtils utils;
    public MessageUtil messageUtil;
    public StorageClass storage;
    public VersionHandler versionHandler;

    public void onEnable() {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "" + ChatColor.BOLD + "[SimpleTpa] If you need support contact me at https://discord.gg/SZUkza9");
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "" + ChatColor.BOLD + "[SimpleTpa] Simple Tpa has been enabled on version " + this.getDescription().getVersion());
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new DeathEvent(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new MoveEvent(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new JoinAndLeaveEvents(this), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new TeleportEvent(this), (Plugin)this);
        this.getCommand("tpa").setExecutor((CommandExecutor)new TpaCommand(this));
        this.getCommand("tpahere").setExecutor((CommandExecutor)new TpaHereCommand(this));
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TpdenyCommand(this));
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpacceptCommand(this));
        this.getCommand("tpcancel").setExecutor((CommandExecutor)new TpcancelCommand(this));
        this.getCommand("tpahereall").setExecutor((CommandExecutor)new TpahereallCommand(this));
        this.getCommand("tpatoggle").setExecutor((CommandExecutor)new TpaToggleCommand(this));
        this.getCommand("simpletpa").setExecutor((CommandExecutor)new SimpleTpaCommand(this));
        this.getCommand("tpaignore").setExecutor((CommandExecutor)new TpaIgnoreCommand(this));
        this.getCommand("tpauto").setExecutor((CommandExecutor)new TpautoCommand(this));
        if (!this.getConfig().getBoolean("disable-back-command")) {
            this.getCommand("back").setExecutor((CommandExecutor)new BackCommand(this));
        }
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        MetricsLite metrics = new MetricsLite((Plugin)this, 5510);
        if (metrics.isEnabled()) {
            Bukkit.getServer().getLogger().info("Enabled metrics. You may opt-out by changing plugins/bStats/config.yml");
        }
        new UpdateChecker((Plugin)this, 64270).getVersion(version -> {
            if (!this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "[SimpleTpa] There is a new update available.");
                Bukkit.broadcastMessage((String)(ChatColor.RED + "[SimpleTpa] There is a new update available:"));
                Bukkit.broadcastMessage((String)(ChatColor.RED + "[SimpleTpa] https://www.spigotmc.org/resources/simple-tpa.64270/"));
            }
        });
        this.utils = new SimpleTpaUtils(this);
        this.messageUtil = new MessageUtil(this);
        this.storage = new StorageClass(this);
        this.formatNMSVersion();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new SimpleTpaExpansion(this).register();
        }
    }

    public void onDisable() {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "[SimpleTpa] If you need support contact me at https://discord.gg/SZUkza9");
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "[SimpleTpa] Simple Tpa has been disabled on version " + this.getDescription().getVersion());
        this.storage.locationBackPlayers.clear();
        this.storage.tpaRequest.clear();
        this.storage.backCommandLocation.clear();
        this.storage.backCooldown.clear();
        this.storage.tpaCooldown.clear();
        this.storage.locationPlayers.clear();
        this.storage.tpaHereAllCooldown.clear();
        this.storage.tpaHereAllRequest.clear();
        this.storage.tpaHereCooldown.clear();
        this.storage.tpaHereRequest.clear();
        this.storage.tpaToggled.clear();
    }

    private void setTabCompleters() {
        this.getCommand("tpa").setTabCompleter((TabCompleter)new TpaCommandTabCompletion(this));
        this.getCommand("tpahere").setTabCompleter((TabCompleter)new TpaHereCommandTabCompletion(this));
        this.getCommand("tpcancel").setTabCompleter((TabCompleter)new TpcancelCommandTabCompletion(this));
        this.getCommand("tpatoggle").setTabCompleter((TabCompleter)new TpaToggleCommandTabCompletion(this));
        if (!this.getConfig().getBoolean("disable-back-command")) {
            this.getCommand("back").setTabCompleter((TabCompleter)new BackCommandTabCompletion(this));
        }
    }

    public void formatNMSVersion() {
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String token = pkg.substring(pkg.lastIndexOf(46) + 1);
        if ("craftbukkit".equalsIgnoreCase(token)) {
            this.versionHandler = new Handler_v1_13(this);
            this.setTabCompleters();
            this.storage.setAbove16(true);
            return;
        }
        int[] v = new int[3];
        boolean ok = SimpleTpa.parseNmsToken(token, v);
        if (!ok) {
            throw new IllegalArgumentException(token + " isn't a known version! Please contact me in my discord support server! https://discord.com/invite/SZUkza9");
        }
        if (v[0] == 1 && v[1] < 13) {
            this.versionHandler = null;
            return;
        }
        this.versionHandler = new Handler_v1_13(this);
        this.setTabCompleters();
        if (v[0] > 1 || v[0] == 1 && v[1] >= 16) {
            this.storage.setAbove16(true);
        }
    }

    private static boolean parseNmsToken(String token, int[] outMajorMinorRev) {
        Pattern P = Pattern.compile("^v(\\d+)_(\\d+)_R(\\d+)$");
        Matcher m = P.matcher(token);
        if (!m.matches()) {
            return false;
        }
        try {
            outMajorMinorRev[0] = Integer.parseInt(m.group(1));
            outMajorMinorRev[1] = Integer.parseInt(m.group(2));
            outMajorMinorRev[2] = Integer.parseInt(m.group(3));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

