/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa.utils;

import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import me.mulemuledupe.simpletpa.SimpleTpa;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SimpleTpaUtils {
    SimpleTpa plugin;
    private Set<Material> dangerousBlocks = EnumSet.noneOf(Material.class);

    public SimpleTpaUtils(SimpleTpa plugin) {
        this.plugin = plugin;
        this.initDangerousBlocks();
    }

    public boolean isVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public void sendMessage(Player p, String message) {
        if (!message.equalsIgnoreCase("none")) {
            if (!this.plugin.getConfig().getBoolean("disable-prefix")) {
                this.plugin.messageUtil.sendMessage(p, this.plugin.getConfig().getString("prefix") + " " + message);
            } else {
                this.plugin.messageUtil.sendMessage(p, message);
            }
        }
    }

    public void addButtonsMethod(Player p) {
        String acceptRaw = this.plugin.getConfig().getString("Accept-Button", "Accept");
        boolean acceptBold = this.plugin.getConfig().getBoolean("Accept-Button-Set-Bold", false);
        String acceptHoverRaw = this.plugin.getConfig().getString("Accept-Button-Description", "");
        String acceptColor = this.plugin.getConfig().getString("Accept-Button-Color", "");
        String middleRaw = this.plugin.getConfig().getString("Middle-Button", " | ");
        boolean middleBold = this.plugin.getConfig().getBoolean("Middle-Button-Set-Bold", false);
        String middleHoverRaw = this.plugin.getConfig().getString("Middle-Button-Description", "");
        String middleColor = this.plugin.getConfig().getString("Middle-Button-Color", "");
        String denyRaw = this.plugin.getConfig().getString("Deny-Button", "Deny");
        boolean denyBold = this.plugin.getConfig().getBoolean("Deny-Button-Set-Bold", false);
        String denyHoverRaw = this.plugin.getConfig().getString("Deny-Button-Description", "");
        String denyColor = this.plugin.getConfig().getString("Deny-Button-Color", "");
        TextComponent acceptBtn = this.buildButton(acceptRaw, acceptColor, acceptBold, acceptHoverRaw, "/tpaccept");
        TextComponent middleBtn = this.buildButton(middleRaw, middleColor, middleBold, middleHoverRaw, null);
        TextComponent denyBtn = this.buildButton(denyRaw, denyColor, denyBold, denyHoverRaw, "/tpdeny");
        p.spigot().sendMessage(new BaseComponent[]{acceptBtn, middleBtn, denyBtn});
    }

    private net.md_5.bungee.api.ChatColor safeColor(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return net.md_5.bungee.api.ChatColor.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private void applyDefaults(BaseComponent[] comps, net.md_5.bungee.api.ChatColor defColor, boolean defBold) {
        for (BaseComponent bc : comps) {
            try {
                if (defColor != null && bc.getColor() == null) {
                    bc.setColor(defColor);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                if (!defBold || bc.isBold()) continue;
                bc.setBold(Boolean.valueOf(true));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    private TextComponent buildButton(String raw, String colorName, boolean bold, String hoverRaw, String runCmd) {
        BaseComponent[] baseComponentArray;
        String text;
        String string = text = bold ? "&l" + raw : raw;
        if (this.plugin.messageUtil.hasUserColoring(raw)) {
            baseComponentArray = this.plugin.messageUtil.toComponents(text);
        } else {
            BaseComponent[] baseComponentArray2 = new BaseComponent[1];
            baseComponentArray = baseComponentArray2;
            baseComponentArray2[0] = new TextComponent(raw);
        }
        BaseComponent[] comps = baseComponentArray;
        net.md_5.bungee.api.ChatColor defColor = this.safeColor(colorName);
        this.applyDefaults(comps, defColor, bold);
        TextComponent btn = new TextComponent(comps);
        if (runCmd != null) {
            btn.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, runCmd));
        }
        btn.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.plugin.messageUtil.toComponents(hoverRaw)));
        return btn;
    }

    private void tryPlayConfiguredSound(Player player) {
        if (this.plugin.versionHandler == null || this.plugin.getConfig().getBoolean("disable-sound")) {
            return;
        }
        String name = this.plugin.getConfig().getString("Sound-Name");
        try {
            Sound s = Sound.valueOf((String)name);
            this.plugin.versionHandler.sendSound(player, s);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            this.plugin.getLogger().warning("[SimpleTpa] Invalid Sound-Name in config: " + name + ". Skipping sound.");
        }
    }

    public boolean cancelRequest(Player p) {
        if (this.plugin.storage.tpaRequest.containsKey(p.getUniqueId())) {
            Player player = Bukkit.getPlayer((UUID)this.plugin.storage.tpaRequest.get(p.getUniqueId()));
            if (player != null) {
                this.sendMessage(player, this.plugin.getConfig().getString("Timed-Out-Message"));
            }
            this.plugin.storage.tpaRequest.remove(p.getUniqueId());
            return true;
        }
        return false;
    }

    public void sendRequest(Player sender, Player receiver) {
        this.sendMessage(sender, this.replacePlaceholders(receiver, this.plugin.getConfig().getString("Sending-Teleport-Request")));
        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-sound")) {
            this.tryPlayConfiguredSound(receiver);
        }
        this.sendMessage(receiver, this.replacePlaceholders(sender, this.plugin.getConfig().getString("Sent-Request-On-You")));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Time-Left").replace("%seconds%", String.valueOf(this.plugin.getConfig().getInt("keep-alive"))));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Accept-Message"));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Deny-Message"));
        this.plugin.storage.tpaRequest.put(receiver.getUniqueId(), sender.getUniqueId());
        if (!this.plugin.getConfig().getBoolean("disable-accept-deny-buttons")) {
            this.addButtonsMethod(receiver);
        }
    }

    public boolean cancelTRequest(Player p) {
        if (this.plugin.storage.tpaHereRequest.containsKey(p.getUniqueId())) {
            Player player = Bukkit.getPlayer((UUID)this.plugin.storage.tpaHereRequest.get(p.getUniqueId()));
            if (player != null) {
                this.sendMessage(player, this.plugin.getConfig().getString("Timed-Out-Here-Message"));
            }
            this.plugin.storage.tpaHereRequest.remove(p.getUniqueId());
            return true;
        }
        return false;
    }

    public void sendTRequest(Player sender, Player receiver) {
        this.sendMessage(sender, this.replacePlaceholders(receiver, this.plugin.getConfig().getString("Sending-Teleport-Here-Request")));
        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-sound")) {
            this.tryPlayConfiguredSound(receiver);
        }
        this.sendMessage(receiver, this.replacePlaceholders(sender, this.plugin.getConfig().getString("Sent-Here-Request-On-You")));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Time-Left").replace("%seconds%", String.valueOf(this.plugin.getConfig().getInt("keep-alive"))));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Accept-Message"));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Deny-Message"));
        this.plugin.storage.tpaHereRequest.put(receiver.getUniqueId(), sender.getUniqueId());
        if (!this.plugin.getConfig().getBoolean("disable-accept-deny-buttons")) {
            this.addButtonsMethod(receiver);
        }
    }

    public boolean cancelTAllRequest(Player p) {
        if (this.plugin.storage.tpaHereAllRequest.containsKey(p.getUniqueId())) {
            if (p != null) {
                this.sendMessage(p, this.plugin.getConfig().getString("Timed-Out-Here-Message"));
            }
            this.plugin.storage.tpaHereAllRequest.remove(p.getUniqueId());
            return true;
        }
        return false;
    }

    public void sendTAllRequest(Player sender, Player receiver) {
        this.sendMessage(sender, this.plugin.getConfig().getString("Teleport-Message-Back-To-Sender-TPHEREALL"));
        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-sound")) {
            this.tryPlayConfiguredSound(receiver);
        }
        this.sendMessage(receiver, this.replacePlaceholders(sender, this.plugin.getConfig().getString("Sent-Here-Request-On-You")));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Time-Left").replace("%seconds%", String.valueOf(this.plugin.getConfig().getInt("keep-alive"))));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Accept-Message"));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Deny-Message"));
        this.plugin.storage.tpaHereAllRequest.put(receiver.getUniqueId(), sender.getUniqueId());
        if (!this.plugin.getConfig().getBoolean("disable-accept-deny-buttons")) {
            this.addButtonsMethod(receiver);
        }
    }

    public void consoleSendMessage(CommandSender sender) {
        String prefix = this.plugin.getConfig().getString("prefix") + " ";
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + this.plugin.getConfig().getString("Console-Isnt-Player"))));
    }

    public boolean checkDisabledWorlds(Player p) {
        if (this.plugin.getConfig().getStringList("disabled-worlds").contains(p.getWorld().getName())) {
            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Disabled-World-Message"));
            return false;
        }
        return true;
    }

    public void runInvincibilityTask(Player p) {
        if (!this.plugin.getConfig().getBoolean("disable-invincibility") && this.plugin.versionHandler != null) {
            this.plugin.versionHandler.setVuneralbleMethod(p, true);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.versionHandler.setVuneralbleMethod(p, false), (long)this.plugin.getConfig().getInt("invincibility-seconds") * 20L);
        }
    }

    public boolean checkGamemode(Player player, Player sender) {
        if (!this.plugin.getConfig().getBoolean("disable-gamemode-check")) {
            String v = Bukkit.getServer().getClass().getPackage().getName();
            if ((v = v.substring(v.lastIndexOf(46) + 1)).equalsIgnoreCase("v1_7_R1") || v.equalsIgnoreCase("v1_7_R2") || v.equalsIgnoreCase("v1_7_R3") || v.equalsIgnoreCase("v1_7_R4")) {
                return true;
            }
            if (player != null && player.getGameMode() == GameMode.SPECTATOR) {
                if (sender != null && !sender.equals(player)) {
                    this.sendMessage(sender, this.replacePlaceholders(player, this.plugin.getConfig().getString("Player-In-Spectator")));
                } else {
                    this.sendMessage(player, this.plugin.getConfig().getString("Different-Gamemode"));
                }
                return false;
            }
        }
        return true;
    }

    public boolean safeTeleport(Player player, Location targetLoc) {
        int y;
        boolean nether;
        if (this.plugin.getConfig().getBoolean("disable-safe-teleport-on-back")) {
            player.teleport(targetLoc);
            return true;
        }
        if (this.isSafeLocation(targetLoc)) {
            player.teleport(targetLoc);
            return true;
        }
        Location up1 = targetLoc.clone().add(0.0, 1.0, 0.0);
        Location down1 = targetLoc.clone().add(0.0, -1.0, 0.0);
        if (this.isSafeLocation(up1)) {
            player.teleport(up1);
            return true;
        }
        if (this.isSafeLocation(down1)) {
            player.teleport(down1);
            return true;
        }
        World world = targetLoc.getWorld();
        if (world == null) {
            this.sendMessage(player, this.plugin.getConfig().getString("No-Safe-Location"));
            return false;
        }
        int origX = targetLoc.getBlockX();
        int origY = targetLoc.getBlockY();
        int origZ = targetLoc.getBlockZ();
        int maxRadius = this.plugin.getConfig().getInt("safe-teleport.radius", 5);
        int verticalCap = this.plugin.getConfig().getInt("safe-teleport.vertical-cap", 64);
        for (int radius = 1; radius <= maxRadius; ++radius) {
            for (int dy = -2; dy <= 2; ++dy) {
                int checkY = origY + dy;
                if (checkY < this.minWorldY(world) || checkY >= world.getMaxHeight() - 2) continue;
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        Location cand;
                        if (Math.abs(dx) != radius && Math.abs(dz) != radius || !this.isSafeLocation(cand = new Location(world, (double)(origX + dx) + 0.5, (double)checkY, (double)(origZ + dz) + 0.5))) continue;
                        player.teleport(cand);
                        return true;
                    }
                }
            }
        }
        int minY = Math.max(this.minWorldY(world), origY - verticalCap);
        int maxY = Math.min(world.getMaxHeight() - 2, origY + verticalCap);
        boolean bl = nether = world.getEnvironment() == World.Environment.NETHER;
        if (nether) {
            for (y = origY; y >= minY; --y) {
                Location loc = new Location(world, (double)origX + 0.5, (double)y, (double)origZ + 0.5);
                if (!this.isSafeLocation(loc)) continue;
                player.teleport(loc);
                this.sendMessage(player, this.plugin.getConfig().getString("No-Safe-Location"));
                return true;
            }
            for (y = origY; y <= maxY; ++y) {
                Location loc = new Location(world, (double)origX + 0.5, (double)y, (double)origZ + 0.5);
                if (!this.isSafeLocation(loc)) continue;
                player.teleport(loc);
                this.sendMessage(player, this.plugin.getConfig().getString("No-Safe-Location"));
                return true;
            }
        } else {
            for (y = origY; y <= maxY; ++y) {
                Location loc = new Location(world, (double)origX + 0.5, (double)y, (double)origZ + 0.5);
                if (!this.isSafeLocation(loc)) continue;
                player.teleport(loc);
                this.sendMessage(player, this.plugin.getConfig().getString("No-Safe-Location"));
                return true;
            }
            for (y = origY; y >= minY; --y) {
                Location loc = new Location(world, (double)origX + 0.5, (double)y, (double)origZ + 0.5);
                if (!this.isSafeLocation(loc)) continue;
                player.teleport(loc);
                this.sendMessage(player, this.plugin.getConfig().getString("No-Safe-Location"));
                return true;
            }
        }
        this.sendMessage(player, this.plugin.getConfig().getString("No-Safe-Location"));
        return false;
    }

    private boolean isSafeLocation(Location loc) {
        Block ground = loc.clone().subtract(0.0, 1.0, 0.0).getBlock();
        Block feet = loc.getBlock();
        Block head = feet.getRelative(0, 1, 0);
        if (!ground.getType().isSolid() && !this.isAcceptableNonSolidGround(ground.getType())) {
            return false;
        }
        if (this.isDangerous(ground.getType())) {
            return false;
        }
        if (feet.getType().isSolid()) {
            return false;
        }
        if (this.isDangerous(feet.getType())) {
            return false;
        }
        if (head.getType().isSolid()) {
            return false;
        }
        if (this.isDangerous(head.getType())) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                Block adjacent = feet.getRelative(dx, 0, dz);
                if (this.isDangerous(adjacent.getType())) {
                    return false;
                }
                adjacent = head.getRelative(dx, 0, dz);
                if (!this.isDangerous(adjacent.getType())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAcceptableNonSolidGround(Material mat) {
        return mat == Material.WATER;
    }

    private void initDangerousBlocks() {
        String[] names;
        for (String n : names = new String[]{"LAVA", "FIRE", "CACTUS", "MAGMA_BLOCK", "SWEET_BERRY_BUSH", "CAMPFIRE", "SOUL_CAMPFIRE", "POWDER_SNOW"}) {
            Material m = this.matchMaterialCompat(n);
            if (m == null) continue;
            this.dangerousBlocks.add(m);
        }
    }

    private Material matchMaterialCompat(String name) {
        try {
            return Material.matchMaterial((String)name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean isDangerous(Material mat) {
        return this.dangerousBlocks.contains(mat);
    }

    public String replacePlaceholders(Player target, String message) {
        return message.replace("%player%", target.getName()).replace("%username%", target.getDisplayName());
    }

    private int minWorldY(World w) {
        try {
            return w.getMinHeight();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }
}

