/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa.utils;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.mulemuledupe.simpletpa.SimpleTpa;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class MessageUtil {
    private final SimpleTpa plugin;
    private final Pattern gradientPattern = Pattern.compile("<gradient:#([0-9a-fA-F]{6}):#([0-9a-fA-F]{6})>(.*?)</gradient>");
    private final Pattern hexPattern = Pattern.compile("#[a-fA-F0-9]{6}");

    public MessageUtil(SimpleTpa plugin) {
        this.plugin = plugin;
    }

    public void sendMessage(Player p, String message) {
        if (message.equalsIgnoreCase("none")) {
            return;
        }
        String finalMessage = message;
        if (!this.plugin.getConfig().getBoolean("disable-prefix")) {
            String prefix = this.plugin.getConfig().getString("prefix");
            String cleanPrefix = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)prefix));
            String cleanMessage = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            if (!cleanMessage.startsWith(cleanPrefix)) {
                finalMessage = prefix + " " + message;
            }
        }
        p.sendMessage(this.parseGradients(finalMessage));
    }

    public String parseGradients(String text) {
        if (!this.plugin.storage.isAbove16()) {
            return this.translate(text).replaceAll("<gradient:#[0-9a-fA-F]{6}:#[0-9a-fA-F]{6}>", "").replaceAll("</gradient>", "");
        }
        Matcher gradientMatcher = this.gradientPattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (gradientMatcher.find()) {
            String startColor = "#" + gradientMatcher.group(1);
            String endColor = "#" + gradientMatcher.group(2);
            String content = gradientMatcher.group(3);
            String gradientText = this.createGradient(content, startColor, endColor);
            gradientMatcher.appendReplacement(sb, gradientText);
        }
        gradientMatcher.appendTail(sb);
        return this.translate(sb.toString());
    }

    private String createGradient(String text, String startHex, String endHex) {
        if (text.isEmpty()) {
            return "";
        }
        text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        ChatColor startColor = ChatColor.of((String)startHex);
        ChatColor endColor = ChatColor.of((String)endHex);
        int length = text.length();
        StringBuilder result = new StringBuilder();
        StringBuilder activeFormatting = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7' && i + 1 < length) {
                char formatChar = text.charAt(i + 1);
                activeFormatting.append('\u00a7').append(formatChar);
                result.append('\u00a7').append(formatChar);
                ++i;
                continue;
            }
            double ratio = (double)i / (double)(length - 1);
            result.append(this.interpolateColor(startColor, endColor, ratio));
            if (activeFormatting.length() > 0) {
                result.append((CharSequence)activeFormatting);
            }
            result.append(c);
        }
        return result.toString();
    }

    private String interpolateColor(ChatColor start, ChatColor end, double ratio) {
        int r = (int)((double)start.getColor().getRed() + ratio * (double)(end.getColor().getRed() - start.getColor().getRed()));
        int g = (int)((double)start.getColor().getGreen() + ratio * (double)(end.getColor().getGreen() - start.getColor().getGreen()));
        int b = (int)((double)start.getColor().getBlue() + ratio * (double)(end.getColor().getBlue() - start.getColor().getBlue()));
        return ChatColor.of((Color)new Color(r, g, b)).toString();
    }

    public String translate(String string) {
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        if (this.plugin.storage.isAbove16()) {
            Matcher hexMatcher = this.hexPattern.matcher(string);
            StringBuffer sb = new StringBuffer();
            while (hexMatcher.find()) {
                String color = hexMatcher.group();
                hexMatcher.appendReplacement(sb, ChatColor.of((String)color).toString());
            }
            hexMatcher.appendTail(sb);
            string = sb.toString();
        }
        return string;
    }

    public BaseComponent[] toComponents(String text) {
        String parsed = this.parseGradients(text);
        return TextComponent.fromLegacyText((String)parsed);
    }

    public boolean hasUserColoring(String s) {
        if (s == null) {
            return false;
        }
        return s.contains("<gradient:") || s.matches(".*#[a-fA-F0-9]{6}.*") || s.indexOf(38) >= 0;
    }
}

